﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.Text

Public Class MainForm

    ' 声明必需的类变量。
    Private CommPort As New RS232()
    Private IsModemFound As Boolean = False
    Private ModemPort As Integer = 0


    ' 此子例程检查本地计算机上的可用端口。它通过
    ' 尝试打开端口 1 到 4 完成此任务。
    Private Sub CheckForPortsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckForPortsButton.Click

        ' 检查 4 个 Comm 端口中每个端口的可用性，并在具有
        ' 可打开端口的列表框项中放置一个选中标记。
        Dim i As Integer
        For i = 1 To 4
            WriteMessage("Testing COM" + i.ToString())
            If IsPortAvailable(i) Then
                ' 选中可用端口的框。
                Me.PortsList.SetItemChecked(i - 1, True)
            Else
                ' 取消选择不可用端口的框。
                Me.PortsList.SetItemChecked(i - 1, False)
            End If
        Next
        ' 启用“Find Modems”（查找调制解调器）按钮。
        Me.CheckModemsButton.Enabled = True
    End Sub

    ' 此子例程尝试将一个 AT 命令发送到任何活动的 Comm 端口。
    ' 如果返回了响应，则表明在该端口上检测到了可用的
    ' 调制解调器。
    Private Sub CheckModemsButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckModemsButton.Click
        Dim i As Integer
        For i = 0 To 3
            If Me.PortsList.GetItemChecked(i) Then
                ' 选中了该项，因此它可能是有效端口。
                ' 测试有效性。
                If IsPortAvailable(i + 1) Then
                    ' 检查端口是否对 AT 命令做出响应。
                    If IsPortAModem(i + 1) Then
                        ' 将类变量设置为最后找到的调制解调器。
                        Me.IsModemFound = True
                        Me.ModemPort = i + 1
                        ' 向用户写入消息。
                        WriteMessage("Port " + (i + 1).ToString() + _
                            " is a responsive modem.")
                    Else
                        ' 向用户写入消息。
                        WriteMessage("Port " + (i + 1).ToString() + _
                            " is not a responsive modem.")
                    End If
                End If
            End If
        Next
        ' 如果查找到一个调制解调器，则应启用其他按钮，这样用户
        ' 可与该调制解调器进行交互。
        If Me.IsModemFound Then
            Me.SelectedModemTextbox.Text = "Using Modem on COM" + _
                Me.ModemPort.ToString()
            Me.UserCommandTextbox.Enabled = True
            Me.SendATCommandButton.Enabled = True
            Me.SendUserCommandButton.Enabled = True
        End If
    End Sub


    ' 此子例程清除文本框。
    Private Sub ClearButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClearButton.Click
        Me.StatusTextbox.Clear()
    End Sub


    ' 此子例程向调制解调器发送一个 AT 命令，并记录其响应。
    ' 它依赖计时器读取响应。
    Private Sub SendATCommandButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SendATCommandButton.Click

        ' 始终将 Comm 端口的使用封装在异常处理程序中。
        Try
            ' 启用计时器。
            Me.tmrReadCommPort.Enabled = True
            ' 试图打开端口。
            CommPort.Open(ModemPort, 115200, 8, RS232.DataParity.Parity_None, _
                RS232.DataStopBit.StopBit_1, 4096)

            ' 向端口写入一个 AT 命令。
            CommPort.Write(Encoding.ASCII.GetBytes("AT" & Chr(13)))
            ' 休眠足够长的时间以使调制解调器进行响应，计时器激发。
            System.Threading.Thread.Sleep(200)
            Application.DoEvents()
            CommPort.Close()

        Catch ex As Exception
            ' 警告用户。
            MessageBox.Show("Unable to communicate with Modem")
        Finally
            ' 禁用计时器。
            Me.tmrReadCommPort.Enabled = False
        End Try

    End Sub


    ' 此子例程向调制解调器发送一个用户指定的命令，并记录其
    ' 响应。它依赖计时器读取响应。
    Private Sub SendUserCommandButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SendUserCommandButton.Click

        ' 始终将 Comm 端口的使用封装在异常处理程序中。
        Try
            ' 启用计时器。
            Me.tmrReadCommPort.Enabled = True
            ' 试图打开端口。
            CommPort.Open(ModemPort, 115200, 8, RS232.DataParity.Parity_None, RS232.DataStopBit.StopBit_1, 4096)

            ' 向端口写入一个用户指定的命令。
            CommPort.Write(Encoding.ASCII.GetBytes(Me.UserCommandTextbox.Text & Chr(13)))
            ' 休眠足够长的时间以使调制解调器进行响应，计时器激发。
            System.Threading.Thread.Sleep(200)
            Application.DoEvents()
            CommPort.Close()

        Catch ex As Exception
            ' 警告用户。
            MessageBox.Show("Unable to communicate with Modem")
        Finally
            ' 禁用计时器。
            Me.tmrReadCommPort.Enabled = False
        End Try

    End Sub

    ' 此子例程在引发了计时器事件时激发，它将
    ' Comm 端口缓冲区中的所有内容写入到输出窗口。
    Private Sub tmrReadCommPort_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles tmrReadCommPort.Tick
        Try
            ' 只要存在信息，则每次读取一个字节，并将其
            ' 输出。
            While (CommPort.Read(1) <> -1)
                ' 向屏幕写入输出。
                WriteMessage(Chr(CommPort.InputStream(0)), False)
            End While
        Catch exc As Exception
            ' 在没有可读取的信息时引发异常。
            ' 此处不应执行任何操作，让异常进行。
        End Try

    End Sub


    ' 此函数检查端口是否为调制解调器，方法是
    ' 向端口发送一个 AT 命令。如果端口响应，则
    ' 假定它是调制解调器。此函数返回 Boolean 值。
    Private Function IsPortAModem(ByVal port As Integer) As Boolean

        ' 始终将 Comm 端口的使用封装在异常处理程序中。
        Try
            ' 试图打开端口。
            CommPort.Open(port, 115200, 8, RS232.DataParity.Parity_None, _
                RS232.DataStopBit.StopBit_1, 4096)

            ' 向端口写入一个 AT 命令。
            CommPort.Write(Encoding.ASCII.GetBytes("AT" & Chr(13)))
            ' 休眠足够长的时间以使调制解调器进行响应。
            System.Threading.Thread.Sleep(200)
            Application.DoEvents()
            ' 尝试从 Comm 端口获取信息。
            Try
                ' 尝试读取一个字节。如果获取了一个字节，则假定
                ' 端口包含一个调制解调器。在离开之前先清除
                ' 缓冲区。
                CommPort.Read(1)
                CommPort.ClearInputBuffer()
                CommPort.Close()
                Return True
            Catch exc As Exception
                ' 没有要从 Comm 端口读取的内容，因此设置为 False
                CommPort.Close()
                Return False
            End Try
        Catch exc As Exception
            ' 端口未能打开或向其中写入。
            Me.PortsList.SetItemChecked(port - 1, False)
            MsgBox("Could not open port.", MsgBoxStyle.OKOnly, Me.Text)
            Return False
        End Try


    End Function

    ' 此函数尝试打开经过的 Comm 端口。如果这可用，则
    ' 返回 True，否则返回 False。为确定可用性，
    ' 使用了 Try-Catch 块。
    Private Function IsPortAvailable(ByVal ComPort As Integer) As Boolean
        Try
            CommPort.Open(ComPort, 115200, 8, RS232.DataParity.Parity_None, _
                RS232.DataStopBit.StopBit_1, 4096)
            ' 如果得到的结果如下所示，则该 Comm 端口可用。
            CommPort.Close()
            Return True
        Catch
            ' 如果得到的结果如下所示，则打开 Comm 端口的尝试
            ' 不成功。
            Return False
        End Try
    End Function

    ' 此子例程向 txtStatus 文本框写入一条消息。
    Private Sub WriteMessage(ByVal message As String)
        Me.StatusTextbox.Text += message + vbCrLf
    End Sub

    ' 此子例程向 txtStatus 文本框写入一条消息，并允许
    ' 取消显示换行符。
    Private Sub WriteMessage(ByVal message As String, ByVal linefeed As Boolean)
        Me.StatusTextbox.Text += message
        If linefeed Then
            Me.StatusTextbox.Text += vbCrLf
        End If
    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        End
    End Sub
End Class
